#!/usr/bin/python
from glob import glob
import sys

s = 0
t = 2
l = "200"
addtomenu = indexlink = indextemplate = path = table = template = ""
extlen = 5
indexpath = "_GB_.html"
indextitle = "NO Title!"
filetype = ".jpeg"
maxsubmenu = 10
print("\nGalleryBuilder v2.01 by Mario Corsolini - www.oipaz.net")

def appcr(string, app):
    return string[:-len("\n")] + app + "\n"

def js(fn):
    return fn.replace("&","&amp;").replace(chr(8216),"&lsquo;").replace(chr(8217),"&rsquo;")

def slash(win):
    return win.replace("\\", "/")

def space(n):
    sp = ""
    for i in range(n):
        sp += " "
    return sp

for i in range(len(sys.argv)):
    if sys.argv[i][:3] == "-a:":
        maxsubmenu = int(sys.argv[i][3:])
        if maxsubmenu < 1:
            maxsubmenu = 1
    if sys.argv[i][:3] == "-i:":
        indextemplate = sys.argv[i][3:]
    if sys.argv[i][:3] == "-d:":
        path = slash(sys.argv[i][3:])
        if not path.endswith("/"):
            path +="/"
    if sys.argv[i][:3] == "-f:":
        template = sys.argv[i][3:]
        if template != "":
            filetype = ".html"
    if sys.argv[i][:3] == "-l:":
        indexlink = sys.argv[i][3:]
    if sys.argv[i][:3] == "-t:":
        indextitle = sys.argv[i][3:]
    if sys.argv[i][:3] == "-s:":
        l = sys.argv[i][3:]

if (len(sys.argv) == 1) or ("-h" in sys.argv) or (indextemplate == ""):
    print("    GalleryBuilder builds an HTML page (default: _GB_.html) with links")
    print("    to all .jpeg (xor .png) images contained in a specified directory,")
    print("    using .jpg files as thumbnails and .txt files as comments.\n")
    print("    Usage:\nGalleryBuilder.py -i:path [options]\n\n    Options:")
    print("-i:path     address of the index template (required)")
    print("-d:path     directory containing images, thumbnails and comments (rel to root)")
    print("-f:file     creates a full HTML gallery using file as template")
    print("-l:file     address of the index page (to be used with -f, rel to -d)")
    print("-t:title    title of the index page (to be used with -f, use quotes)")
    print("-s:n        side length of thumbnails, in pixels (default: n=200)")
    print("-e          exit without asking for confirmation")
    print("-h          print these notes and exit")
    if ("-e" not in sys.argv):
        print("\nPress <Enter> to Continue...")
        sys.stdin.readline()
    sys.exit()

for line in open(indextemplate):
    line = line.replace("#GB-Index_title#", indextitle)
    if line.find("#GB-TheGallery#") >= 0:
        s = line.find("#GB-TheGallery#")
        image = glob(path + "*.jpeg")
        if len(image) == 0:
            image = glob(path + "*.png")
            extlen = 4
            if filetype == ".jpeg":
                filetype = ".png"
        for i in range(len(image)):
            jpegname = image[i][len(path):-extlen]
            table += space(s) + "<div class=\"gallery\">\n"
            table += space(s+t) + "<a href=\"" + js(slash(image[i][:-extlen]).replace(" ","%20")) + filetype + "\" id=\"Img" + str(i+1) + "\">\n"
            table += space(s+2*t) + "<img src=\"" + js(slash(image[i][:-extlen]).replace(" ","%20")) + ".jpg\" title=\" "  + js(jpegname) + " \" alt=\"[" + js(jpegname) + "]\" width=\"" + l + "\" height=\"" + l + "\">\n"
            table += space(s+t) + "</a>\n"
            table += space(s+t) + "<p>\n"
            table += space(s+2*t) + "<a href=\"" + js(slash(image[i][:-extlen]).replace(" ","%20")) + filetype + "\">\n"
            table += space(s+3*t) + "<span style=\"display:block;text-align:center;\"><strong>" + js(jpegname) + "</strong></span>\n"
            table += space(s+2*t) + "</a>\n"
            try:
                txtcomment = ""
                for txtline in open(image[i][:-extlen] + ".txt"):
                    txtcomment += txtline.replace("\n"," ")
                table += space(s+2*t) + txtcomment + "\n"
            except:
                pass
            table += space(s+t) + "</p>\n"
            table += space(s) + "</div>\n"
            if i % maxsubmenu == 0:
                addtomenu += space(3*t) + "var GalleryBuilder" + str(1 + int(i/maxsubmenu)).zfill(2) + " = GalleryBuilder.addItem(\"\", \"<strong>#" + str(int(maxsubmenu*(i/maxsubmenu)+1)).zfill(2) + "&ndash;#" + str(min(int(maxsubmenu*(i/maxsubmenu)+maxsubmenu),len(image))).zfill(2) + "</strong>\", \"color:#002000;text-decoration:none;\").addSubMenu();\n"
            addtomenu += space(4*t) + "GalleryBuilder" + str(1 + int(i/maxsubmenu)).zfill(2) + ".addItem(\"" + js(slash(image[i][:-extlen]).replace(" ","%20")) + filetype + "\", \"<strong>" + js(image[i][len(path):-extlen]) + "</strong>\");\n"
    else:
        table += line
if indexlink != "":
    indexpath = indexlink.replace("../", "").replace("..\\", "")
output = open(indexpath, "w")
output.write(table)
output.close()
if len(image) == 1:
    print("  " + indexpath + " successfully created with 1 image.")
else:
    print("  " + indexpath + " successfully created with " + str(len(image)) + " images.")
if "-a:" + str(maxsubmenu) in sys.argv:
    output = open(indexpath + ".AddToMenu.txt", "w")
    output.write(addtomenu)
    output.close()
    print("  " + indexpath + ".AddToMenu.txt successfully created.")

if template != "":
    for i in range(len(image)):
        html = ""
        for line in open(template):
            line = line.replace("#GB-Index_link#", indexlink)
            line = line.replace("#GB-Index_img#", indexlink + "#Img" + str(i+1))
            line = line.replace("#GB-Index_title#", indextitle)
            line = line.replace("#GB-Filename#", js(image[i][len(path):-extlen]))
            if extlen == 5:
                line = line.replace("#GB-Filename.ext#", js(image[i][len(path):-extlen].replace(" ","%20")) + ".jpeg")
            else:
                line = line.replace("#GB-Filename.ext#", js(image[i][len(path):-extlen].replace(" ","%20")) + ".png")
            line = line.replace("#GB-#n/N#", "#" + str(i+1) + "/" + str(len(image)))
            if line.find("#GB-Asx#") >= 0:
                if i == 0:
                    line = ""
                else:
                    line = line.replace("#GB-Asx#","<a class=\"sx\" href=\"" + js(image[i-1][len(path):-extlen].replace(" ","%20")) + ".html\" title=\" &lt; (" + js(image[i-1][len(path):-extlen]) + ")\"></a>")
            if line.find("#GB-Adx#") >= 0:
                if i == len(image)-1:
                    line = ""
                else:
                    line = line.replace("#GB-Adx#","<a class=\"dx\" href=\"" + js(image[i+1][len(path):-extlen].replace(" ","%20")) + ".html\" title=\" &gt; (" + js(image[i+1][len(path):-extlen]) + ")\"></a>")
            if line.find("#GB-First#") >= 0:
                if i == 0:
                    line = line.replace("#GB-First#", "")
                else:
                    line = line.replace("#GB-First#", "<a href=\"" + js(image[0][len(path):-extlen].replace(" ","%20")) + ".html\" style=\"text-decoration:none\" title=\" " + js(image[0][len(path):-extlen]) + " \">")
                    line = appcr(line, "</a>")
            if line.find("#GB-Previous#") >= 0:
                if i == 0:
                    line = line.replace("#GB-Previous#", "")
                else:
                    line = line.replace("#GB-Previous#", "<a href=\"" + js(image[i-1][len(path):-extlen].replace(" ","%20"))  + ".html\" style=\"text-decoration:" + "none\" title=\" " + js(image[i-1][len(path):-extlen]) + " \">")
                    line = appcr(line, "</a>")
            if line.find("#GB-Next#") >= 0:
                if i == len(image)-1:
                    line = line.replace("#GB-Next#", "")
                else:
                    line = line.replace("#GB-Next#", "<a href=\"" + js(image[i+1][len(path):-extlen].replace(" ","%20")) + ".html\" style=\"text-decoration:none\" title=\" " + js(image[i+1][len(path):-extlen]) + " \">")
                    line = appcr(line, "</a>")
            if line.find("#GB-Last#") >= 0:
                if i == len(image)-1:
                    line = line.replace("#GB-Last#", "")
                else:
                    line = line.replace("#GB-Last#", "<a href=\"" + js(image[len(image)-1][len(path):-extlen].replace(" ","%20")) + ".html\" style=\"" + "text-decoration:none\" title=\" " + js(image[len(image)-1][len(path):-extlen]) + " \">")
                    line = appcr(line, "</a>")
            html = html + line
        output = open(slash(image[i][:-extlen] + ".html"), "w")
        output.write(html)
        output.close()
        formattedoutput = "File #{0:>0" + str(len(str(len(image)))) + "}/{1} created: {2}"
        print(formattedoutput.format(i+1, str(len(image)), slash(js(image[i][:-extlen]) + ".html")))

if ("-e" not in sys.argv):
    print("\nPress <Enter> to Continue...")
    sys.stdin.readline()
