#!/usr/bin/python
import ftplib
import time
import sys
try:
    from urllib.request import urlopen
except ImportError:
    from urllib2 import urlopen

def ISO8601(AddSec):
    UTCtime = time.strftime("%Y-%m-%dT%H:%M:%S", time.gmtime())
    if (AddSec == False):
        UTCtime = UTCtime[:-3]
    UTCtime = UTCtime + "Z"
    return UTCtime

def SaveToLog(LogEntry):
    try:
        IPadrLog = open(LogPath + time.strftime("%Y", time.gmtime()) + "_IPadr.log", "a")
        IPadrLog.write(LogEntry + "\n")
        IPadrLog.close()
    except:
        pass
    return

WaitMod = 0
FTPpassword = FTPusername = URI = LogPath = ""
for i in range(len(sys.argv)):
    if sys.argv[i][:3] == "-l:":
        LogPath = sys.argv[i][3:]
    if sys.argv[i][:3] == "-m:":
        WaitMod = int(sys.argv[i][3:])
    if sys.argv[i][:3] == "-p:":
        FTPpassword = sys.argv[i][3:]
    if sys.argv[i][:3] == "-u:":
        FTPusername = sys.argv[i][3:]
    if sys.argv[i][:3] == "-w:":
        URI = sys.argv[i][3:]
        if (URI[:6] != "ftp://"):
            URI = ""
        URI = URI[6:]

if ((len(sys.argv) == 1) or ("-h" in sys.argv) or (FTPpassword == "") or (FTPusername == "") or (URI == "") or (WaitMod < 0) or (WaitMod > 60)):
    print("\0")
    print("    IPadr v1.42 by Mario Corsolini")
    print("    IPadr publishes on a web page the public IP address of a (NATted) host")
    print("    and it keeps a text log of its operations")
    print("    Usage:\nIPadr.py -w:URI -u:NAME -p:PW [-l:PATH] [-m:N] [-c] [-h]\n\n    Options:")
    print("-c      ask for confirmation before exiting")
    print("-h      print these notes and exit")
    print("-l:PATH save logs in the provided path")
    print("-m:N    wait until minutes are congruent to 0 (mod N)")
    print("-p:PW   FTP password")
    print("-u:NAME FTP username")
    print("-w:URI  FTP address of the directory receiving IPadr.html\n")
    sys.exit()

if (WaitMod > 0):
    while (int(time.strftime("%M", time.gmtime())) % WaitMod != 0):
        time.sleep(.941)
SaveToLog(ISO8601(True) + " - HTTP GET: Starting")
try:
    u = urlopen("http://www.oipaz.net/getIPadr.shtml")
    PublicIP = u.read().decode("ascii")
    u.close()
    SaveToLog(ISO8601(True) + " - HTTP GET: OK")
except:
    pass
i = PublicIP.find("var IPadr = '")
if ((i > 0) and (len(PublicIP) >= i + 28)):
    PublicIP = PublicIP[i+13:i+29]
    i = PublicIP.find("'")
    if (i > 7):
        PublicIP = PublicIP[:i]
        SaveToLog(ISO8601(True) + " - IPadr: " + PublicIP)
        try:
            LocalFile = open(LogPath + "IPadr.html", "w")
            LocalFile.write(ISO8601(False) + " - IPadr: " + PublicIP)
            LocalFile.close()
        except:
            pass
        SaveToLog(ISO8601(True) + " - FTP PUT: Starting")
        try:
            i = URI.find("/")
            FTPserv = ftplib.FTP(URI[:i], FTPusername, FTPpassword)
            FTPserv.cwd(URI[i+1:])
            LocalFile = open(LogPath + "IPadr.html", "rb")
            FTPresp = FTPserv.storbinary("STOR IPadr.html", LocalFile)
            LocalFile.close()
            FTPserv.close()
            if (FTPresp[:3] == "226"):
                SaveToLog(ISO8601(True) + " - FTP PUT: OK")
        except:
            pass
        SaveToLog("+")

if ("-c" in sys.argv):
    print("Press <Enter> to Continue...")
    sys.stdin.readline()
