#!/usr/bin/python
import datetime
import math
import time
import sys

datapath = lastip = gbuf = ""
ipfilter = [-1, -1, -1, -1]
n = tot = igui = 0
optc = optn = optz = False
yfr = yto = int(time.strftime("%Y"))
gui = " 1234567890"
dt = ndt = -1
print("\0")

def divideip(ip):
    ipa = ip[:ip.find(".")]
    ipb = ip[len(ipa)+1:ip.find(".",len(ipa)+1)]
    ipc = ip[len(ipa)+len(ipb)+2:ip.find(".",len(ipa)+len(ipb)+2)]
    ipd = ip[len(ipa)+len(ipb)+len(ipc)+3:]
    return (ipa, ipb, ipc, ipd)

if "-h" in sys.argv:
    print("    IPadrLog v1.42 by Mario Corsolini")
    print("    IPadrLog analyses the log files created by IPadr")
    print("    Usage:\nIPadrLog.py [options]\n\n    Options:")
    print("-3                 format IPv4 addresses as numbers of exactly three digits")
    print("-c                 ask for confirmation before exiting")
    print("-f:A|*.B|*.C|*.D|* show only the IPv4 addresses matching the provided pattern")
    print("-h                 print these notes and exit")
    print("-l:PATH            look for logs in the provided path")
    print("-n                 add line numbers")
    print("-s[:STRING]        code the -t:M table with STRING (default is \" 1234567890\")")
    print("-t:M               table cyclicly coded addresses in time frames of M minutes")
    print("-y:YEAR1[-[YEAR2]] analyse data from YEAR1 to YEAR2 (use four-digit numbers)")
    sys.exit()

for i in range(len(sys.argv)):
    if sys.argv[i] == "-3":
        optz = True
    if sys.argv[i] == "-c":
        optc = True
    if sys.argv[i][:3] == "-t:":
        if ((int(sys.argv[i][3:]) >= 1) and (int(sys.argv[i][3:]) <= 1440)):
            dt = datetime.timedelta(0, int(sys.argv[i][3:]) * 60)
            ndt = math.ceil(1440 / int(sys.argv[i][3:]))
    if sys.argv[i][:2] == "-s":
        if (len(sys.argv[i]) > 4):
            gui = sys.argv[i][3:]
    if sys.argv[i][:3] == "-f:":
        for j in range(4):
            if divideip(sys.argv[i][3:])[j] != "*":
                try:
                    ipfilter[j] = int(divideip(sys.argv[i][3:])[j])
                except:
                    pass
    if sys.argv[i] == "-n":
        optn = True
    if sys.argv[i][:3] == "-l:":
        datapath = sys.argv[i][3:]
    if sys.argv[i][:3] == "-y:":
        try:
            if len(sys.argv[i]) == 7:
                yfr = int(sys.argv[i][3:])
                yto = yfr
            elif len(sys.argv[i]) == 8 and sys.argv[i][7] == "-":
                yfr = int(sys.argv[i][3:7])
            elif len(sys.argv[i]) == 12 and sys.argv[i][7] == "-":
                yfr = int(sys.argv[i][3:7])
                yto = int(sys.argv[i][8:12])
        except:
            pass
        if yfr > yto:
            y = yto
            yto = yfr
            yfr = y
        if yfr < 1970:
            yfr = 1970
        if yto < 1970:
            yto = 1970
        if yfr > int(time.strftime("%Y")):
            yfr = int(time.strftime("%Y"))
        if yto > int(time.strftime("%Y")):
            yto = int(time.strftime("%Y"))

if (dt == -1):
    for i in range(yfr, yto + 1):
        try:
            log = open(datapath + str(i) + "_IPadr.log")
            line = log.readline()
            while line:
                idx = line.find("IPadr:")
                if idx > 0 and len(line) > idx + 7:
                    tot = tot + 1
                    ip = line[idx+7:-1]
                    if ip[-1] == "\r":
                        ip = ip[:-1]
                    if ip != lastip:
                        if ipfilter[0] == -1 or ipfilter[0] == int(divideip(ip)[0]):
                            if ipfilter[1] == -1 or ipfilter[1] == int(divideip(ip)[1]):
                                if ipfilter[2] == -1 or ipfilter[2] == int(divideip(ip)[2]):
                                    if ipfilter[3] == -1 or ipfilter[3] == int(divideip(ip)[3]):
                                        n = n + 1
                                        lastip = ip
                                        if optn:
                                            buf = format(n, "6d") + "   "
                                        else:
                                            buf = ""
                                        if optz:
                                            ip = divideip(ip)
                                            ip = format(int(ip[0]),"03d") + "." + format(int(ip[1]),"03d") + "." + format(int(ip[2]),"03d") + "." + format(int(ip[3]),"03d")
                                        print(buf + line[:16] + line[19].strip() + "   " + ip)
                line = log.readline()
            log.close()
            print("\0")
        except IOError as err:
            print(err)
else:
    for i in range(yfr, yto + 1):
        t0 = datetime.datetime(i, 1, 1, 0, 0, 0)
        buf = str(t0)[:10] + "   "
        try:
            log = open(datapath + str(i) + "_IPadr.log")
            line = log.readline()
            while line:
                idx = line.find("IPadr:")
                if idx > 0 and len(line) > idx + 7:
                    while (str(t0)[:10] != line[:10]):
                        buf = (buf + gbuf[-1:] + 1440 * gui[0])[:int(ndt+13)]
                        print(buf)
                        t0 = t0 + datetime.timedelta(1)
                        t0 = datetime.datetime(i, t0.month, t0.day, 0, 0, 0)
                        buf = str(t0)[:10] + "   "
                        gbuf = ""
                    while (datetime.datetime.strptime(line[:19], "%Y-%m-%dT%H:%M:%S") >= t0 + dt):
                        if (gbuf != ""):
                            buf = buf + gbuf[-1:]
                            gbuf = ""
                        else:
                            buf = buf + gui[0]
                        t0 = t0 + dt
                    tot = tot + 1
                    ip = line[idx+7:-1]
                    if ip[-1] == "\r":
                        ip = ip[:-1]
                    if ipfilter[0] == -1 or ipfilter[0] == int(divideip(ip)[0]):
                        if ipfilter[1] == -1 or ipfilter[1] == int(divideip(ip)[1]):
                            if ipfilter[2] == -1 or ipfilter[2] == int(divideip(ip)[2]):
                                if ipfilter[3] == -1 or ipfilter[3] == int(divideip(ip)[3]):
                                    n = n + 1
                                    if ip != lastip:
                                        lastip = ip
                                        igui = igui + 1
                                        if (igui >= len(gui)):
                                            igui = 1
                                    gbuf = gbuf + gui[igui]
                line = log.readline()
            log.close()
            print(buf + "\n")
        except IOError as err:
            print(err)

if n == 0:
    print("No Matching Data.")
buf = format(tot, "6d") + " Entr"
if tot == 1:
    buf = buf + "y"
else:
    buf = buf + "ies"
print(buf + " Found.\n")

if optc:
    print("Press <Enter> to Continue...")
    sys.stdin.readline()
